#!/usr/bin/env python
# -*- coding: utf-8 -*- 

# Importujemy niezbędne moduły
from gimpfu import *

# GIMP w systemie Windows nie bardzo wie co zrobić z zastosowaniem 
# funkcji drukowania "print" dlatego: Definiujemy funkcję wyjścia "gprint", 
# aby przekierowała wiadomości do Konsoli błędów.
def gprint( text ):  
    pdb.gimp_message(text)
    return 

# Definiujemy Naszą funkcję, która będzie wykonywać faktyczne czynności
def plugin_function(image, drawable, text_value, int_value) :

    gprint("Hello World! ")
    gprint("Wyślij ten tekst: "+text_value)
    gprint("Wyślij tą cyfrę: %d"%int_value)
    gprint("Umożliwia również odwrócenie obrazu!")
    pdb.gimp_image_flip( image, ORIENTATION_HORIZONTAL )

    return

# Rejestrujemy wtyczkę w PDB
register(
    "plugin_debug", # Nazwa rejestrowanej wtyczki w Przeglądarce procedur, 
	# oraz nazwa pojawiająca się na krawędzi okna wtyczki   
    "Pierwsza wtyczka Python-Fu ",   
    "Ta wtyczka nic nie robi, poza wysłaniem komunikatów do Konsoli błędów",
    "Michel Ardan, Modified Zbyma72age", 
    "Michel Ardan (alfa.beta@gmail.com) Company GPL", 
    "April 2010, Modyfied 2015",
    "Przekierowanie komunikatów drukowania do konsoli błędów...", # Etykieta
    "", 
    [
      (PF_IMAGE, "image", "Input image", None),
      (PF_DRAWABLE, "drawable", "Input drawable", None),
	  (PF_STRING, 'some_text', 'Wprowadź jakiś tekst', 'Piszemy cokolwiek'),
      (PF_INT, 'some_integer', 'Wprowadź jakąś cyfrę', 2010)
    ], 
    [],
    plugin_function, menu="<Image>/TEST/Testowanie/"
    )
"""
 Otwieramy Konsolę błędów, uruchamiamy tą wtyczkę i patrzymy 
 na to, co otrzymamy jako wyjście do Konsoli błędów. Odwrócenie (odbicie)
 obrazu widać natychmiast.
 """
main()
 
 